﻿/*
 * このファイルでは、
 * http://csharper.blog57.fc2.com/blog-entry-234.html
 * を参考に呼び出し元のコールスタックを使用している。
 */

using System.Diagnostics;
using System.Reflection;
using System.Security;
using log4net;

namespace Framework.Log
{
    /// <summary>
    /// ロガーを取得するために使用するロガーのプールです。
    /// </summary>
    public static class LoggerPool
    {
        /// <summary>
        /// 呼び出し元のクラス名をキーにしてロガーを取得します。
        /// </summary>
        [DynamicSecurityMethod]
        public static ILogger GetLogger()
        {
            const int callerFrameIndex = 1;
            StackFrame callerFrame = new StackFrame(callerFrameIndex);
            MethodBase callerMethod = callerFrame.GetMethod();
            return new Logger(LogManager.GetLogger(callerMethod.DeclaringType));
        }
    }
}

// HACK : 上述のページ参照
namespace System.Security
{
    [AttributeUsage(AttributeTargets.Method, AllowMultiple = true, Inherited = false)]
    internal sealed class DynamicSecurityMethodAttribute : Attribute
    {
    }
}